/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
$(document).ready(function () {
    $(".state_selection").change(function () {
        var stateId = $(this).val();
        var stateTx = $(this).find('option:selected').text();
        $(".state_name").val(stateTx);
        $.ajax({
            url: "process/API_AjaxCalling.php",
            type: 'POST', // http method
            data: "state=" + stateId + "&type=option&mode=state",
            success: function (result) {
//                console.log("SUCCESS :: " + result);
                if (result) {
                    $(".city_selection").html(result);
                }
            },
            error: function (jqXhr, textStatus, errorMessage) {
                console.log("ERROR :: " + errorMessage);
            }
        });
    });

    $(".city_selection").change(function () {
        var stateId = $(this).val();
        var stateTx = $(this).find('option:selected').text();
        $(".city_name").val(stateTx);
    });

//    $(".store_selection").change(function () {
//        var stateId = $(this).val();
//        var stateTx = $(this).find('option:selected').text();
//        $(".store_name").val(stateTx);
//    });

    $(".client_selection").change(function () {
        var clientId = $(this).val();
        var clientTx = $(this).find('option:selected').text();
        var clientUn = $(this).find('option:selected').attr('data-unique');
        $(".client_id").val(clientId);
        if ($(".store_client_unique")) {
            $(".store_client_unique").val(clientUn);
        }
        if ($(".user_client_unique")) {
            $(".user_client_unique").val(clientUn);
        }
    });

    $(".store_selection").change(function () {
        var storeId = $(this).val();
        var storeTx = $(this).find('option:selected').text();
        var storeUn = $(this).find('option:selected').attr('data-unique');
        var storeNm = $(this).find('option:selected').attr('data-name');
        $(".store_id").val(storeId);
        $(".user_store_unique").val(storeUn);
        if ($(".user_store_name")) {
            $(".user_store_name").val(storeNm);
        }
    });

    $(".onlyNumbers").keypress(function (e) {
        //if the letter is not digit then display error and don't type anything
        if (e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
            //display error message
            $("#errmsg").html("Digits Only").show().fadeOut(1000);//"slow");
            return false;
        }
    });
});


function onlyNumbers(thisVal, thisId) {
    thisVal = thisVal.replace(/[^0-9]/g, '');
//    thisVal = thisVal.replace(/(\..*)\./g, '$1');
//    thisVal = thisVal.replace(/^(-?).*?(\d+\.\d{2}).*$/, '$1$2');
    $("#" + thisId).val(thisVal);
}
function getRecordList(recordName = '') {
    console.log("CALLING :: "+recordName);
    $("." + recordName + "_list_data").hide();
    $("." + recordName + "_list_loading").show();
    $.ajax({
        url: "process/API_AjaxCalling.php",
        type: 'POST', // http method
        dataType: 'html',
        data: "mode=" + recordName + "_index",
        async: false,
        success: function (result) {
            console.log("SUCCESS :: " + result);
            if (result) {
                $("." + recordName + "_list").append(result);
                $('.footable').footable();
            }

            $("." + recordName + "_list_loading").hide();
            $("." + recordName + "_list_data").show();
        },
        error: function (jqXhr, textStatus, errorMessage) {
            console.log("ERROR :: " + errorMessage);
        }
    });
}

function getProductList() {
    getRecordList('product');
}

function getStockList() {
    getRecordList('stock');
}

function getInventoryList() {
    getRecordList('inventory');
}

function getSalesList() {
    var extData = '';
    var filterDuration = $("#filterSearch").val();
    if (filterDuration != '') {
        extData = filterDuration;
    }
    $(".sale_list_data").hide();
    $(".sale_list_data").html('');
    $(".sale_list_loading").show();
    $.ajax({
        url: "process/API_AjaxCalling.php",
        type: 'POST', // http method
        dataType: 'html',
        data: "mode=sales_index&" + extData,
        async: false,
        success: function (result) {
//            console.log("SUCCESS :: " + result);
            if (result) {
                $(".sale_list").append(result);
                setSaleData();
            }
        },
        error: function (jqXhr, textStatus, errorMessage) {
            console.log("ERROR :: " + errorMessage);
        }
    });
}


function setSaleData() {
    setTimeout(function () {
        $('.footable').footable();
        $(".sale_list_loading").hide();
        $(".sale_list_data").show();
    }, 600);
}
function getSalesMonthlyList() {
    console.log("CALLING :: ");
    var respponse = '';
    $.ajax({
        url: "process/API_AjaxCalling.php",
        type: 'POST', // http method
        dataType: 'html',
        data: "mode=sales_monthly",
        async: false,
        success: function (result) {
            respponse = result;
            $("#dashSale").val(respponse);
        },
        error: function (jqXhr, textStatus, errorMessage) {
            console.log("ERROR :: " + errorMessage);
        }
    });
//    setTimeout(function () {
////        updateChart();
//    }, 2000);
    return respponse;
}

