<?php require_once './config/dbconfig.php';  ?>
<!doctype html>
<html class="no-js" lang="">

    <head>

        <meta charset="utf-8">

        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

        <title>Admin Dashboard - GPS Tracker by Zohukum</title>

        <meta name="description" content="">

        <meta name="viewport" content="width=device-width, initial-scale=1">

        <?php
        if ($_SESSION[CONST_SESSION_ID] == '') {
//print_r($_SESSION);die;    
            ?>

            <script>

                window.location = "index.php";

            </script>

            <?php
        } else {

            $SQLUserDetails = $DB_Config->runQuery("select * from admin_users where id='" . $_SESSION[CONST_SESSION_ID] . "'");

            $FetchUserDetails = mysqli_fetch_assoc($SQLUserDetails);
        }



        include_once('style.php');
        ?>

    </head>

    <body id="pixel" class="appWrapper">

        <div id="wrap" class="animsition"> 

            <!-- HEADER Content -->

            <?php include_once('inc/header.php'); ?>

            <!--/ HEADER Content  --> 



            <!--  CONTROLS Content -->

            <?php include_once('inc/side_menu.php'); ?>

            <!--/ CONTROLS Content --> 



            <!-- CONTENT -->

            <section id="content">

                <div class="page page-dashboard">

                    <div class="row">

                        <div class="col-md-12">

                            <div class="pageheader">

                                <h2>ZOPOS Solution <span>// By Zohukum</span></h2>

                            </div>

                        </div>

                    </div>

                    <!-- cards row -->

                    <div class="row">

                        <div class="card-container col-lg-3 col-sm-6 col-sm-12">

                            <div class="card">

                                <div class="front bg-white br-5">

                                    <div class="row">

                                        <div class="col-xs-4"> <i class="fa fa-product-hunt fa-4x"></i> </div>

                                        <div class="col-xs-8">

                                            <p class="text-elg text-strong mb-0">
                                                <?php echo $DB_Config->getZoposTableDataCount($_SESSION, 'product_catalog'); ?>
                                            </p>

                                            <span>Products </span> 
                                            <a href="product_list.php" class="pull-right"> 
                                                <i class="fa fa-link"></i>
                                                View
                                            </a>
                                        </div>

                                    </div>

                                </div>

                            </div>

                        </div>
                        <?php if ($_SESSION[CONST_SESSION_LEVEL] == CONST_LEVEL_TYPE_COMPANY) { ?>

                            <div class="card-container col-lg-3 col-sm-6 col-sm-12">

                                <div class="card">

                                    <div class="front bg-white br-5">

                                        <div class="row">

                                            <div class="col-xs-4"> <i class="fa fa-object-group fa-4x"></i> </div>

                                            <div class="col-xs-8">

                                                <p class="text-elg text-strong mb-0">
                                                    <?php echo $DB_Config->getZoposTableDataCount($_SESSION, 'zopos_store_list', false); ?>
                                                </p>

                                                <span>Store </span> 
                                                <a href="store_list.php" class="pull-right"> 
                                                    <i class="fa fa-link"></i>
                                                    View
                                                </a>
                                            </div>

                                        </div>

                                    </div>

                                </div>

                            </div>
                        <?php } ?>

                        <div class="card-container col-lg-3 col-sm-6 col-sm-12">

                            <div class="card">

                                <div class="front bg-white br-5">

                                    <div class="row">

                                        <div class="col-xs-4"> <i class="fa fa-user fa-4x"></i> </div>

                                        <div class="col-xs-8">

                                            <p class="text-elg text-strong mb-0">
                                                <?php echo $DB_Config->getZoposTableDataCount($_SESSION, 'zopos_user_list', false); ?>
                                            </p>

                                            <span>User </span> 
                                            <a href="user_list.php" class="pull-right"> 
                                                <i class="fa fa-link"></i>
                                                View
                                            </a>
                                        </div>

                                    </div>

                                </div>

                            </div>

                        </div>

                        <div class="card-container col-lg-3 col-sm-6 col-sm-12">

                            <div class="card">

                                <div class="front bg-white br-5">

                                    <div class="row">

                                        <div class="col-xs-4"> <i class="fa fa-inr fa-4x"></i> </div>

                                        <div class="col-xs-8">

                                            <p class="text-elg text-strong mb-0">
                                                <?php
                                                $numberFormat = $DB_Config->getZoposTableDataCount($_SESSION, 'sale', true, " sum(to_pay) as CNT ", 'to_pay');
                                                echo number_format($numberFormat, 2, ".", ",");
                                                ?>
                                            </p>


                                            <span>Total Sale</span> 
                                            <a href="sales_list.php" class="pull-right"> 
                                                <i class="fa fa-link"></i>
                                                View
                                            </a>
                                        </div>

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="row" style="display: none;">

                        <div class="col-md-8">

                            <section class="tile">

                                <div class="tile-header dvd dvd-btm">

                                    <h1 class="custom-font"><strong>Visitors </strong>Statistics</h1>

                                    <ul class="controls">

                                        <li class="dropdown"> <a role="button" tabindex="0" class="dropdown-toggle settings" data-toggle="dropdown"> <i class="fa fa-cog"></i> <i class="fa fa-spinner fa-spin"></i> </a>

                                            <ul class="dropdown-menu pull-right with-arrow animated littleFadeInUp">

                                                <li> <a role="button" tabindex="0" class="tile-toggle"> <span class="minimize"><i class="fa fa-angle-down"></i>&nbsp;&nbsp;&nbsp;Minimize</span> <span class="expand"><i class="fa fa-angle-up"></i>&nbsp;&nbsp;&nbsp;Expand</span> </a> </li>

                                                <li> <a role="button" tabindex="0" class="tile-refresh"> <i class="fa fa-refresh"></i> Refresh </a> </li>

                                                <li> <a role="button" tabindex="0" class="tile-fullscreen"> <i class="fa fa-expand"></i> Fullscreen </a> </li>

                                            </ul>

                                        </li>

                                        <li class="remove"><a role="button" tabindex="0" class="tile-close"><i class="fa fa-times"></i></a></li>

                                    </ul>

                                </div>

                                <div class="tile-widget">

                                    <div id="regions_div" style="width:100% ; height:410px; overflow:hidden;"></div>

                                </div>

                                <div class="tile-body">

                                    <div class="row">

                                        <div class="col-md-6 col-sm-12">

                                            <div class="progress-list">

                                                <div class="details">

                                                    <div class="title">America</div>

                                                    <div class="description">visitor from america</div>

                                                </div>

                                                <div class="status pull-right"> <span>40</span>% </div>

                                                <div class="clearfix"></div>

                                                <div class="progress-xs not-rounded progress">

                                                    <div class="progress-bar progress-bar-dutch" role="progressbar" aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width: 40%"> <span class="sr-only">40%</span> </div>

                                                </div>

                                            </div>

                                            <div class="progress-list">

                                                <div class="details">

                                                    <div class="title">Canada</div>

                                                    <div class="description">visitor from Canada</div>

                                                </div>

                                                <div class="status pull-right"> <span>38</span>% </div>

                                                <div class="clearfix"></div>

                                                <div class="progress-xs not-rounded progress">

                                                    <div class="progress-bar progress-bar-greensea" role="progressbar" aria-valuenow="38" aria-valuemin="0" aria-valuemax="100" style="width: 31%"> <span class="sr-only">38%</span> </div>

                                                </div>

                                            </div>

                                            <div class="progress-list">

                                                <div class="details">

                                                    <div class="title">Asia</div>

                                                    <div class="description">visitor from asia</div>

                                                </div>

                                                <div class="status pull-right"> <span>12</span>% </div>

                                                <div class="clearfix"></div>

                                                <div class="progress-xs not-rounded progress">

                                                    <div class="progress-bar progress-bar-lightred" role="progressbar" aria-valuenow="12" aria-valuemin="0" aria-valuemax="100" style="width: 22%"> <span class="sr-only">12%</span> </div>

                                                </div>

                                            </div>

                                        </div>

                                        <div class="col-md-6 col-sm-12">

                                            <div class="progress-list">

                                                <div class="details">

                                                    <div class="title">Germany</div>

                                                    <div class="description">visitor from Germany</div>

                                                </div>

                                                <div class="status pull-right"> <span>7</span>% </div>

                                                <div class="clearfix"></div>

                                                <div class="progress-xs not-rounded progress">

                                                    <div class="progress-bar progress-bar-blue" role="progressbar" aria-valuenow="7" aria-valuemin="0" aria-valuemax="100" style="width: 19%"> <span class="sr-only">7%</span> </div>

                                                </div>

                                            </div>

                                            <div class="progress-list">

                                                <div class="details">

                                                    <div class="title">France</div>

                                                    <div class="description">visitor from France</div>

                                                </div>

                                                <div class="status pull-right"> <span>6</span>% </div>

                                                <div class="clearfix"></div>

                                                <div class="progress-xs not-rounded progress">

                                                    <div class="progress-bar progress-bar-orange" role="progressbar" aria-valuenow="6" aria-valuemin="0" aria-valuemax="100" style="width: 15%"> <span class="sr-only">6%</span> </div>

                                                </div>

                                            </div>

                                            <div class="progress-list">

                                                <div class="details">

                                                    <div class="title">Other</div>

                                                    <div class="description">visitor from other</div>

                                                </div>

                                                <div class="status pull-right"> <span>6</span>% </div>

                                                <div class="clearfix"></div>

                                                <div class="progress-xs not-rounded progress">

                                                    <div class="progress-bar progress-bar-hotpink" role="progressbar" aria-valuenow="6" aria-valuemin="0" aria-valuemax="100" style="width: 6%"> <span class="sr-only">6%</span> </div>

                                                </div>

                                            </div>

                                        </div>

                                    </div>

                                </div>

                            </section>

                        </div>

                        <div class="col-md-4">

                            <section class="tile" fullscreen="isFullscreen02">

                                <div class="tile-header dvd dvd-btm">

                                    <h1 class="custom-font"><strong>Browser </strong>Usage</h1>

                                    <ul class="controls">

                                        <li class="dropdown"> <a role="button" tabindex="0" class="dropdown-toggle settings" data-toggle="dropdown"> <i class="fa fa-cog"></i> <i class="fa fa-spinner fa-spin"></i> </a>

                                            <ul class="dropdown-menu pull-right with-arrow animated littleFadeInUp br-5">

                                                <li> <a role="button" tabindex="0" class="tile-toggle"> <span class="minimize"><i class="fa fa-angle-down"></i>&nbsp;&nbsp;&nbsp;Minimize</span> <span class="expand"><i class="fa fa-angle-up"></i>&nbsp;&nbsp;&nbsp;Expand</span> </a> </li>

                                                <li> <a role="button" tabindex="0" class="tile-refresh"> <i class="fa fa-refresh"></i> Refresh </a> </li>

                                                <li> <a role="button" tabindex="0" class="tile-fullscreen"> <i class="fa fa-expand"></i> Fullscreen </a> </li>

                                            </ul>

                                        </li>

                                        <li class="remove"><a role="button" tabindex="0" class="tile-close"><i class="fa fa-times"></i></a></li>

                                    </ul>

                                </div>

                                <div class="tile-widget">

                                    <div id="browser-usage" style="height: 250px"></div>

                                </div>

                                <div class="tile-body p-0">

                                    <div class="panel-group icon-plus" id="accordion" role="tablist" aria-multiselectable="true">

                                        <div class="panel panel-default panel-transparent">

                                            <div class="panel-heading" role="tab" id="headingOne">

                                                <h4 class="panel-title"> <a data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne"> <span><i class="fa fa-minus text-sm mr-5"></i> This Month</span> <span class="badge pull-right bg-lightred">3</span> </a> </h4>

                                            </div>

                                            <div id="collapseOne" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingOne">

                                                <div class="panel-body">

                                                    <table class="table table-no-border m-0">

                                                        <tbody>

                                                            <tr>

                                                                <td>1</td>

                                                                <td>Chrome</td>

                                                                <td>6985</td>

                                                                <td><i class="fa fa-caret-up text-success"></i></td>

                                                            </tr>

                                                            <tr>

                                                                <td>2</td>

                                                                <td>Other</td>

                                                                <td>2697</td>

                                                                <td><i class="fa fa-caret-up text-success"></i></td>

                                                            </tr>

                                                            <tr>

                                                                <td>3</td>

                                                                <td>Safari</td>

                                                                <td>3597</td>

                                                                <td><i class="fa fa-caret-down text-danger"></i></td>

                                                            </tr>

                                                            <tr>

                                                                <td>4</td>

                                                                <td>Firefox</td>

                                                                <td>2145</td>

                                                                <td><i class="fa fa-caret-up text-success"></i></td>

                                                            </tr>

                                                            <tr>

                                                                <td>5</td>

                                                                <td>Internet Explorer</td>

                                                                <td>1854</td>

                                                                <td><i class="fa fa-caret-down text-danger"></i></td>

                                                            </tr>

                                                            <tr>

                                                                <td>6</td>

                                                                <td>Opera</td>

                                                                <td>654</td>

                                                                <td><i class="fa fa-caret-up text-success"></i></td>

                                                            </tr>

                                                        </tbody>

                                                    </table>

                                                </div>

                                            </div>

                                        </div>

                                        <div class="panel panel-default panel-transparent">

                                            <div class="panel-heading" role="tab" id="headingTwo">

                                                <h4 class="panel-title"> <a class="collapsed" data-toggle="collapse" data-parent="#accordion" href="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo"> <span><i class="fa fa-minus text-sm mr-5"></i> Last Month</span> </a> </h4>

                                            </div>

                                            <div id="collapseTwo" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingTwo">

                                                <div class="panel-body">

                                                    <table class="table table-no-border m-0">

                                                        <tbody>

                                                            <tr>

                                                                <td>1</td>

                                                                <td>Chrome</td>

                                                                <td>6985</td>

                                                                <td><i class="fa fa-caret-up text-success"></i></td>

                                                            </tr>

                                                            <tr>

                                                                <td>2</td>

                                                                <td>Other</td>

                                                                <td>2697</td>

                                                                <td><i class="fa fa-caret-up text-success"></i></td>

                                                            </tr>

                                                            <tr>

                                                                <td>3</td>

                                                                <td>Safari</td>

                                                                <td>3597</td>

                                                                <td><i class="fa fa-caret-down text-danger"></i></td>

                                                            </tr>

                                                            <tr>

                                                                <td>4</td>

                                                                <td>Firefox</td>

                                                                <td>2145</td>

                                                                <td><i class="fa fa-caret-up text-success"></i></td>

                                                            </tr>

                                                            <tr>

                                                                <td>5</td>

                                                                <td>Internet Explorer</td>

                                                                <td>1854</td>

                                                                <td><i class="fa fa-caret-down text-danger"></i></td>

                                                            </tr>

                                                            <tr>

                                                                <td>6</td>

                                                                <td>Opera</td>

                                                                <td>654</td>

                                                                <td><i class="fa fa-caret-up text-success"></i></td>

                                                            </tr>

                                                        </tbody>

                                                    </table>

                                                </div>

                                            </div>

                                        </div>

                                        <div class="panel panel-default panel-transparent">

                                            <div class="panel-heading" role="tab" id="headingThree">

                                                <h4 class="panel-title"> <a class="collapsed" data-toggle="collapse" data-parent="#accordion" href="#collapseThree" aria-expanded="false" aria-controls="collapseThree"> <span><i class="fa fa-minus text-sm mr-5"></i> This Year</span> </a> </h4>

                                            </div>

                                            <div id="collapseThree" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingThree">

                                                <div class="panel-body">

                                                    <table class="table table-no-border m-0">

                                                        <tbody>

                                                            <tr>

                                                                <td>1</td>

                                                                <td>Chrome</td>

                                                                <td>6985</td>

                                                                <td><i class="fa fa-caret-up text-success"></i></td>

                                                            </tr>

                                                            <tr>

                                                                <td>2</td>

                                                                <td>Other</td>

                                                                <td>2697</td>

                                                                <td><i class="fa fa-caret-up text-success"></i></td>

                                                            </tr>

                                                            <tr>

                                                                <td>3</td>

                                                                <td>Safari</td>

                                                                <td>3597</td>

                                                                <td><i class="fa fa-caret-down text-danger"></i></td>

                                                            </tr>

                                                            <tr>

                                                                <td>4</td>

                                                                <td>Firefox</td>

                                                                <td>2145</td>

                                                                <td><i class="fa fa-caret-up text-success"></i></td>

                                                            </tr>

                                                            <tr>

                                                                <td>5</td>

                                                                <td>Internet Explorer</td>

                                                                <td>1854</td>

                                                                <td><i class="fa fa-caret-down text-danger"></i></td>

                                                            </tr>

                                                            <tr>

                                                                <td>6</td>

                                                                <td>Opera</td>

                                                                <td>654</td>

                                                                <td><i class="fa fa-caret-up text-success"></i></td>

                                                            </tr>

                                                        </tbody>

                                                    </table>

                                                </div>

                                            </div>

                                        </div>

                                    </div>

                                </div>

                            </section>

                        </div>

                    </div>

                    <div class="row" style="display: none;">

                        <div class="col-md-5">

                            <section class="tile">

                                <div class="tile-header dvd dvd-btm">

                                    <h1 class="custom-font"><strong>Realtime </strong>Load</h1>

                                    <ul class="controls">

                                        <li class="dropdown"> <a role="button" tabindex="0" class="dropdown-toggle settings" data-toggle="dropdown"> <i class="fa fa-cog"></i> <i class="fa fa-spinner fa-spin"></i> </a>

                                            <ul class="dropdown-menu pull-right with-arrow animated littleFadeInUp br-5">

                                                <li> <a role="button" tabindex="0" class="tile-toggle"> <span class="minimize"><i class="fa fa-angle-down"></i>&nbsp;&nbsp;&nbsp;Minimize</span> <span class="expand"><i class="fa fa-angle-up"></i>&nbsp;&nbsp;&nbsp;Expand</span> </a> </li>

                                                <li> <a role="button" tabindex="0" class="tile-refresh"> <i class="fa fa-refresh"></i> Refresh </a> </li>

                                                <li> <a role="button" tabindex="0" class="tile-fullscreen"> <i class="fa fa-expand"></i> Fullscreen </a> </li>

                                            </ul>

                                        </li>

                                        <li class="remove"><a role="button" tabindex="0" class="tile-close"><i class="fa fa-times"></i></a></li>

                                    </ul>

                                </div>

                                <div class="tile-widget ">

                                    <div class="progress-list">

                                        <div class="details">

                                            <div class="title text-lg" style="line-height: 30px"><strong>125</strong> Users Online</div>

                                        </div>

                                        <div class="status pull-right bg-amethyst br-50"> <span>41</span>% </div>

                                        <div class="clearfix"></div>

                                        <div class="progress br-50 mb-10" style="height:10px;">

                                            <div class="progress-bar progress-bar-amethyst" role="progressbar" aria-valuenow="41" aria-valuemin="0" aria-valuemax="100" style="width: 41%;"> </div>

                                        </div>

                                    </div>

                                </div>

                                <div class="tile-body p-0 br-5" style="height: 105px; overflow:hidden;">

                                    <div class="rickshaw" id="realtime-rickshaw"></div>

                                </div>

                            </section>

                        </div>

                        <div class="col-md-7">

                            <section class="tile">

                                <div class="tile-header dvd dvd-btm">

                                    <h1 class="custom-font"><strong>Users </strong>Feed</h1>

                                    <ul class="controls">

                                        <li class="dropdown"> <a role="button" tabindex="0" class="dropdown-toggle settings" data-toggle="dropdown"> <i class="fa fa-cog"></i> <i class="fa fa-spinner fa-spin"></i> </a>

                                            <ul class="dropdown-menu pull-right with-arrow animated littleFadeInUp br-5">

                                                <li> <a role="button" tabindex="0" class="tile-toggle"> <span class="minimize"><i class="fa fa-angle-down"></i>&nbsp;&nbsp;&nbsp;Minimize</span> <span class="expand"><i class="fa fa-angle-up"></i>&nbsp;&nbsp;&nbsp;Expand</span> </a> </li>

                                                <li> <a role="button" tabindex="0" class="tile-refresh"> <i class="fa fa-refresh"></i> Refresh </a> </li>

                                                <li> <a role="button" tabindex="0" class="tile-fullscreen"> <i class="fa fa-expand"></i> Fullscreen </a> </li>

                                            </ul>

                                        </li>

                                        <li class="remove"><a role="button" tabindex="0" class="tile-close"><i class="fa fa-times"></i></a></li>

                                    </ul>

                                </div>

                                <div class="tile-widget">

                                    <div class="row">

                                        <div class="col-lg-4">

                                            <div class="media mb-20">

                                                <div class="pull-left thumb"> <img class="media-object br-5" src="assets/images/pi-avatar.jpg" alt=""> </div>

                                                <div class="media-body">

                                                    <h4 class="media-heading mb-0">Imrich <strong>Kamarel</strong></h4>

                                                    <small class="text-lightred">UI/UX Designer</small> </div>

                                            </div>

                                            <div class="row">

                                                <div class="col-xs-4 text-center b-r b-solid"> <small class="text-lightred"><i class="fa fa-heart-o"></i> 125</small> </div>

                                                <div class="col-xs-4 text-center b-r b-solid"> <small class="text-greensea"><i class="fa fa-star-o"></i> 67</small> </div>

                                                <div class="col-xs-4 text-center"> <small class="text-blue"><i class="fa fa-comment-o"></i> 26</small> </div>

                                            </div>

                                        </div>

                                        <div class="col-lg-8">

                                            <dl class="text-sm">

                                                <dt>About : </dt>

                                                <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit.</dd>

                                                <dt>Hobbies : </dt>

                                                <dd>Sleep,  games,  animals, nature</dd>

                                                <dt>Skills : </dt>

                                                <dd>jquery, html, css, angularjs</dd>

                                                <dt>Rating : </dt>

                                                <dd class="text-lightred"><i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star-half-o"></i></dd>

                                            </dl>

                                        </div>

                                    </div>

                                </div>

                            </section>

                        </div>

                    </div>

                    <div class="row" style="display: none;">

                        <div class="col-md-4">

                            <section class="tile tile-simple bg-cyan" style="min-height: 190px; overflow: hidden;">

                                <div class="tile-header">

                                    <h1 class="custom-font">Todos's</h1>

                                    <ul class="controls">

                                        <li class="remove"><a role="button" tabindex="0" class="tile-close"><i class="fa fa-times"></i></a></li>

                                    </ul>

                                </div>

                                <div class="tile-body">

                                    <div id="todo-carousel" class="owl-carousel">

                                        <div>

                                            <div class="progress-list">

                                                <div class="details">

                                                    <div class="title"><i class="fa fa-angle-right mr-5"></i> <span class="text-md">Release update</span></div>

                                                    <div class="description text-transparent-white text-lowercase">high priority, started at: 12.08.2014</div>

                                                </div>

                                                <div class="clearfix" style="height: 45px"></div>

                                                <div class="progress transparent-black not-rounded mb-10" style="height:5px">

                                                    <div class="progress-bar" role="progressbar" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100" style="width: 50%;"> 50% </div>

                                                </div>

                                            </div>

                                            <div class="pull-right">

                                                <button type="button" class="btn btn-border btn-rounded-20 btn-white btn-xs mr-5" style="width:22px;"><i class="fa fa-thumbs-o-up"></i></button>

                                                <button type="button" class="btn btn-border btn-rounded-20 btn-white btn-xs" style="width:22px;"><i class="fa fa-ellipsis-h"></i></button>

                                            </div>

                                            <p class="text-thin">Deadline : <strong>12h 15m</strong></p>

                                        </div>

                                        <div>

                                            <div class="progress-list">

                                                <div class="details">

                                                    <div class="title"><i class="fa fa-angle-right mr-5"></i> <span class="text-md">Fix navigation</span></div>

                                                    <div class="description text-transparent-white text-lowercase">normal priority, started at: 20.09.2014</div>

                                                </div>

                                                <div class="clearfix" style="height: 45px"></div>

                                                <div class="progress transparent-black not-rounded mb-10" style="height:5px">

                                                    <div class="progress-bar" role="progressbar" aria-valuenow="26" aria-valuemin="0" aria-valuemax="100" style="width: 26%;"> 26% </div>

                                                </div>

                                            </div>

                                            <div class="pull-right">

                                                <button type="button" class="btn btn-border btn-rounded-20 btn-white btn-xs mr-5" style="width:22px;"><i class="fa fa-thumbs-o-up"></i></button>

                                                <button type="button" class="btn btn-border btn-rounded-20 btn-white btn-xs" style="width:22px;"><i class="fa fa-ellipsis-h"></i></button>

                                            </div>

                                            <p class="text-thin">Deadline : <strong>2d 9h 45m</strong></p>

                                        </div>

                                        <div>

                                            <div class="progress-list">

                                                <div class="details">

                                                    <div class="title"><i class="fa fa-angle-right mr-5"></i> <span class="text-md">Remove dependencies</span></div>

                                                    <div class="description text-transparent-white text-lowercase">high priority, started at: 26.10.2014</div>

                                                </div>

                                                <div class="clearfix" style="height: 45px"></div>

                                                <div class="progress transparent-black not-rounded mb-10" style="height:5px">

                                                    <div class="progress-bar" role="progressbar" aria-valuenow="78" aria-valuemin="0" aria-valuemax="100" style="width: 78%;"> 78% </div>

                                                </div>

                                            </div>

                                            <div class="pull-right">

                                                <button type="button" class="btn btn-border btn-rounded-20 btn-white btn-xs mr-5" style="width:22px;"><i class="fa fa-thumbs-o-up"></i></button>

                                                <button type="button" class="btn btn-border btn-rounded-20 btn-white btn-xs" style="width:22px;"><i class="fa fa-ellipsis-h"></i></button>

                                            </div>

                                            <p class="text-thin">Deadline : <strong>1h 5m</strong></p>

                                        </div>

                                    </div>

                                </div>

                            </section>

                            <section class="tile tile-simple bg-dutch" style="min-height: 190px; overflow: hidden;">

                                <div class="tile-header">

                                    <h1 class="custom-font"><strong>Social</strong> Feed</h1>

                                    <ul class="controls">

                                        <li class="remove"><a role="button" tabindex="0" class="tile-close"><i class="fa fa-times"></i></a></li>

                                    </ul>

                                </div>

                                <div class="tile-body">

                                    <div id="feed-carousel" class="owl-carousel">

                                        <div class="media social-feed"> <span class="pull-left"> <i class="fa fa-facebook fa-1x icon-border-br-5 wh45 text-center" style="line-height: 45px"></i> </span>

                                            <div class="media-body">

                                                <p class="media-heading"><strong>Imrich Kamarel</strong> <small class="text-light text-transparent-white">18 minutes ago</small></p>

                                                <p class="text-transparent-white">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod ore et dolore magna aliqua. Ut enim ad minim...</p>

                                            </div>

                                        </div>

                                        <div class="media social-feed"> <span class="pull-left"> <i class="fa fa-twitter fa-1x icon-border-br-5 wh45 text-center" style="line-height: 45px"></i> </span>

                                            <div class="media-body">

                                                <p class="media-heading"><strong>George Schwarz</strong> <small class="text-light text-transparent-white">1 hour ago</small></p>

                                                <p class="text-transparent-white">Lorem ipsum dolor sit amet, csed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim...</p>

                                            </div>

                                        </div>

                                        <div class="media social-feed"> <span class="pull-left"> <i class="fa fa-google-plus fa-1x icon-border-br-5 wh45 text-center" style="line-height: 45px"></i> </span>

                                            <div class="media-body">

                                                <p class="media-heading"><strong>Milan Klement</strong> <small class="text-light text-transparent-white">56 minutes ago</small></p>

                                                <p class="text-transparent-white">Lorem ipsum dolor  elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim...</p>

                                            </div>

                                        </div>

                                    </div>

                                </div>

                            </section>

                        </div>

                        <div class="col-md-4">

                            <section class="tile widget-todo" fullscreen="isFullscreen04" ng-controller="TodoWidgetCtrl">

                                <div class="tile-header dvd dvd-btm">

                                    <h1 class="custom-font"><strong>Todo </strong>List</h1>

                                    <ul class="controls">

                                        <li class="dropdown"> <a role="button" tabindex="0" class="dropdown-toggle settings" data-toggle="dropdown"> <i class="fa fa-cog"></i> <i class="fa fa-spinner fa-spin"></i> </a>

                                            <ul class="dropdown-menu pull-right with-arrow animated littleFadeInUp br-5">

                                                <li> <a role="button" tabindex="0" class="tile-toggle"> <span class="minimize"><i class="fa fa-angle-down"></i>&nbsp;&nbsp;&nbsp;Minimize</span> <span class="expand"><i class="fa fa-angle-up"></i>&nbsp;&nbsp;&nbsp;Expand</span> </a> </li>

                                                <li> <a role="button" tabindex="0" class="tile-refresh"> <i class="fa fa-refresh"></i> Refresh </a> </li>

                                                <li> <a role="button" tabindex="0" class="tile-fullscreen"> <i class="fa fa-expand"></i> Fullscreen </a> </li>

                                            </ul>

                                        </li>

                                        <li class="remove"><a role="button" tabindex="0" class="tile-close"><i class="fa fa-times"></i></a></li>

                                    </ul>

                                </div>

                                <div class="tile-body lined-paper">

                                    <form class="form-horizontal" role="form">

                                        <label for="todo" class="text-strong mb-0">Add Todo : </label>

                                        <div class="form-group mb-0">

                                            <div class="col-sm-10">

                                                <input type="text" class="form-control input-unstyled" id="todo" placeholder="type todo here..." required>

                                            </div>

                                            <div class="col-sm-2">

                                                <button type="submit" class="btn btn-link"><i class="fa fa-chevron-right text-lg"></i></button>

                                            </div>

                                        </div>

                                    </form>

                                    <ul class="todo-list list-unstyled">

                                        <li>

                                            <div class="view">

                                                <label class="checkbox checkbox-custom m-0 text-muted inline">

                                                    <input type="checkbox">

                                                    <i></i> </label>

                                                <span>Release Update</span> <a role="button" tabindex="0" class="text-danger remove-todo pull-right"> <i class="fa fa-times"></i> </a> </div>

                                        </li>

                                        <li>

                                            <div class="view">

                                                <label class="checkbox checkbox-custom m-0 text-muted inline">

                                                    <input type="checkbox">

                                                    <i></i> </label>

                                                <span>Make a backup</span> <a role="button" tabindex="0" class="text-danger remove-todo pull-right"> <i class="fa fa-times"></i> </a> </div>

                                        </li>

                                        <li class="completed">

                                            <div class="view">

                                                <label class="checkbox checkbox-custom m-0 text-muted inline">

                                                    <input type="checkbox" checked>

                                                    <i></i> </label>

                                                <span>Send e-mail to Ici</span> <a role="button" tabindex="0" class="text-danger remove-todo pull-right"> <i class="fa fa-times"></i> </a> </div>

                                        </li>

                                        <li>

                                            <div class="view">

                                                <label class="checkbox checkbox-custom m-0 text-muted inline">

                                                    <input type="checkbox">

                                                    <i></i> </label>

                                                <span>Buy tickets</span> <a role="button" tabindex="0" class="text-danger remove-todo pull-right"> <i class="fa fa-times"></i> </a> </div>

                                        </li>

                                        <li>

                                            <div class="view">

                                                <label class="checkbox checkbox-custom m-0 text-muted inline">

                                                    <input type="checkbox">

                                                    <i></i> </label>

                                                <span>Resolve Issues</span> <a role="button" tabindex="0" class="text-danger remove-todo pull-right"> <i class="fa fa-times"></i> </a> </div>

                                        </li>

                                        <li>

                                            <div class="view">

                                                <label class="checkbox checkbox-custom m-0 text-muted inline">

                                                    <input type="checkbox">

                                                    <i></i> </label>

                                                <span>Compile new version</span> <a role="button" tabindex="0" class="text-danger remove-todo pull-right"> <i class="fa fa-times"></i> </a> </div>

                                        </li>

                                    </ul>

                                </div>

                            </section>

                        </div>

                        <div class="col-md-4">

                            <section class="tile widget-chat">

                                <div class="tile-header dvd dvd-btm">

                                    <h1 class="custom-font">Chat</h1>

                                    <ul class="controls">

                                        <li class="dropdown"> <a role="button" tabindex="0" class="dropdown-toggle" data-toggle="dropdown">John Douey <i class="fa fa-angle-down ml-5"></i></a>

                                            <ul class="dropdown-menu pull-right with-arrow animated littleFadeInUp br-5">

                                                <li><a role="button" tabindex="0">Imrich Kamarel</a></li>

                                                <li><a role="button" tabindex="0">Arnold Schwarz</a></li>

                                                <li><a role="button" tabindex="0">Deel McApple</a></li>

                                            </ul>

                                        </li>

                                        <li class="dropdown"> <a role="button" tabindex="0" class="dropdown-toggle settings" data-toggle="dropdown"> <i class="fa fa-cog"></i> <i class="fa fa-spinner fa-spin"></i> </a>

                                            <ul class="dropdown-menu pull-right with-arrow animated littleFadeInUp br-5">

                                                <li> <a role="button" tabindex="0" class="tile-toggle"> <span class="minimize"><i class="fa fa-angle-down"></i>&nbsp;&nbsp;&nbsp;Minimize</span> <span class="expand"><i class="fa fa-angle-up"></i>&nbsp;&nbsp;&nbsp;Expand</span> </a> </li>

                                                <li> <a role="button" tabindex="0" class="tile-refresh"> <i class="fa fa-refresh"></i> Refresh </a> </li>

                                                <li> <a role="button" tabindex="0" class="tile-fullscreen"> <i class="fa fa-expand"></i> Fullscreen </a> </li>

                                            </ul>

                                        </li>

                                        <li class="remove"><a role="button" tabindex="0" class="tile-close"><i class="fa fa-times"></i></a></li>

                                    </ul>

                                </div>

                                <div class="tile-body slim-scroll" style="max-height: 277px;overflow:auto;">

                                    <ul class="chats p-0">

                                        <li class="in">

                                            <div class="media">

                                                <div class="pull-left thumb thumb-sm"> <img class="media-object br-5" src="assets/images/random-avatar2.jpg" alt=""> </div>

                                                <div class="media-body">

                                                    <p class="media-heading"><a role="button" tabindex="0" class="name">John Douey </a><span class="datetime">at 12.10.2014</span></p>

                                                    <span class="body">Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. </span> </div>

                                            </div>

                                        </li>

                                        <li class="out">

                                            <div class="media">

                                                <div class="pull-right thumb thumb-sm"> <img class="media-object br-5" src="assets/images/random-avatar1.jpg" alt=""> </div>

                                                <div class="media-body">

                                                    <p class="media-heading"><a role="button" tabindex="0" class="name">You </a><span class="datetime">2 hours ago</span></p>

                                                    <span class="body">Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. </span> </div>

                                            </div>

                                        </li>

                                        <li class="in">

                                            <div class="media">

                                                <div class="pull-left thumb thumb-sm"> <img class="media-object br-5" src="assets/images/random-avatar2.jpg" alt=""> </div>

                                                <div class="media-body">

                                                    <p class="media-heading"><a role="button" tabindex="0" class="name">John Douey </a><span class="datetime">2 hours ago</span></p>

                                                    <span class="body">Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. </span> </div>

                                            </div>

                                        </li>

                                        <li class="out">

                                            <div class="media">

                                                <div class="pull-right thumb thumb-sm"> <img class="media-object br-5" src="assets/images/random-avatar1.jpg" alt=""> </div>

                                                <div class="media-body">

                                                    <p class="media-heading"><a role="button" tabindex="0" class="name">You </a><span class="datetime">1 hours ago</span></p>

                                                    <span class="body">Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. </span> </div>

                                            </div>

                                        </li>

                                        <li class="in">

                                            <div class="media">

                                                <div class="pull-left thumb thumb-sm"> <img class="media-object br-5" src="assets/images/random-avatar2.jpg" alt=""> </div>

                                                <div class="media-body">

                                                    <p class="media-heading"><a role="button" tabindex="0" class="name">John Douey </a><span class="datetime">53 minutes ago</span></p>

                                                    <span class="body">Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. </span> </div>

                                            </div>

                                        </li>

                                        <li class="out">

                                            <div class="media">

                                                <div class="pull-right thumb thumb-sm"> <img class="media-object br-5" src="assets/images/random-avatar1.jpg" alt=""> </div>

                                                <div class="media-body">

                                                    <p class="media-heading"><a role="button" tabindex="0" class="name">You </a><span class="datetime">40 minutes ago</span></p>

                                                    <span class="body">Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. </span> </div>

                                            </div>

                                        </li>

                                    </ul>

                                </div>

                                <div class="tile-footer">

                                    <div class="chat-form">

                                        <div class="input-group">

                                            <input type="text" class="form-control" placeholder="Type your message here...">

                                            <span class="input-group-btn">

                                                <button class="btn btn-default" type="button"><i class="fa fa-chevron-right"></i></button>

                                            </span> </div>

                                    </div>

                                </div>

                            </section>

                        </div>

                    </div>

                    <div class="row" style="display: none;">

                        <div class="col-md-12">

                            <section class="tile"> 



                                <!-- tile header -->

                                <div class="tile-header dvd dvd-btm">

                                    <h1 class="custom-font"><strong>Project </strong>Progress</h1>

                                    <ul class="controls">

                                        <li> <a role="button" tabindex="0" class="pickDate"> <span></span>&nbsp;&nbsp;<i class="fa fa-angle-down"></i> </a> </li>

                                        <li class="dropdown"> <a role="button" tabindex="0" class="dropdown-toggle settings" data-toggle="dropdown"> <i class="fa fa-cog"></i> <i class="fa fa-spinner fa-spin"></i> </a>

                                            <ul class="dropdown-menu pull-right with-arrow animated littleFadeInUp">

                                                <li> <a role="button" tabindex="0" class="tile-toggle"> <span class="minimize"><i class="fa fa-angle-down"></i>&nbsp;&nbsp;&nbsp;Minimize</span> <span class="expand"><i class="fa fa-angle-up"></i>&nbsp;&nbsp;&nbsp;Expand</span> </a> </li>

                                                <li> <a role="button" tabindex="0" class="tile-refresh"> <i class="fa fa-refresh"></i> Refresh </a> </li>

                                                <li> <a role="button" tabindex="0" class="tile-fullscreen"> <i class="fa fa-expand"></i> Fullscreen </a> </li>

                                            </ul>

                                        </li>

                                        <li class="remove"><a role="button" tabindex="0" class="tile-close"><i class="fa fa-times"></i></a></li>

                                    </ul>

                                </div>

                                <!-- /tile header --> 



                                <!-- tile body -->

                                <div class="tile-body table-custom">

                                    <div class="table-responsive">

                                        <table class="table table-custom" id="project-progress">

                                            <thead>

                                                <tr>

                                                    <th>ID</th>

                                                    <th>Project</th>

                                                    <th>Priority</th>

                                                    <th style="width: 200px;">Status</th>

                                                    <th style="width: 60px;" class="text-right no-sort">Chart</th>

                                                </tr>

                                            </thead>

                                            <tbody>

                                                <tr>

                                                    <td>1</td>

                                                    <td>Graphic layout for client</td>

                                                    <td><small class="text-danger">High Priority</small></td>

                                                    <td><div class="progress-xxs not-rounded mb-0 inline-block progress" style="width: 150px; margin-right: 5px">

                                                            <div class="progress-bar progress-bar-greensea" role="progressbar" aria-valuenow="42" aria-valuemin="0" aria-valuemax="100" style="width: 42%;"></div>

                                                        </div>

                                                        <small>42%</small></td>

                                                    <td class="text-right"><span class="sparklineChart"

                                                                                 values="1,3,2,3,5,6,8,5,9,8"

                                                                                 sparkType="bar"

                                                                                 sparkBarColor="#cd97eb"

                                                                                 sparkBarWidth="4px"

                                                                                 sparkHeight="18px"> Loading...</span></td>

                                                </tr>

                                                <tr>

                                                    <td>2</td>

                                                    <td>Make website responsive</td>

                                                    <td><small class="text-success">Low Priority</small></td>

                                                    <td><div class="progress-xxs not-rounded mb-0 inline-block progress" style="width: 150px; margin-right: 5px">

                                                            <div class="progress-bar progress-bar-greensea" role="progressbar" aria-valuenow="89" aria-valuemin="0" aria-valuemax="100" style="width: 89%;"></div>

                                                        </div>

                                                        <small>89%</small></td>

                                                    <td class="text-right"><span class="sparklineChart"

                                                                                 values="2,5,3,4,6,5,1,8,9,10"

                                                                                 sparkType="bar"

                                                                                 sparkBarColor="#a2d200"

                                                                                 sparkBarWidth="4px"

                                                                                 sparkHeight="18px"> Loading...</span></td>

                                                </tr>

                                                <tr>

                                                    <td>3</td>

                                                    <td>Clean html/css/js code</td>

                                                    <td><small class="text-danger">High Priority</small></td>

                                                    <td><div class="progress-xxs not-rounded mb-0 inline-block progress" style="width: 150px; margin-right: 5px">

                                                            <div class="progress-bar progress-bar-greensea" role="progressbar" aria-valuenow="23" aria-valuemin="0" aria-valuemax="100" style="width: 23%;"></div>

                                                        </div>

                                                        <small>23%</small></td>

                                                    <td class="text-right"><span class="sparklineChart"

                                                                                 values="5,6,8,2,1,6,8,4,3,5"

                                                                                 sparkType="bar"

                                                                                 sparkBarColor="#ffc100"

                                                                                 sparkBarWidth="4px"

                                                                                 sparkHeight="18px"> Loading...</span></td>

                                                </tr>

                                                <tr>

                                                    <td>4</td>

                                                    <td>Database optimization</td>

                                                    <td><small class="text-warning">Normal Priority</small></td>

                                                    <td><div class="progress-xxs not-rounded mb-0 inline-block progress" style="width: 150px; margin-right: 5px">

                                                            <div class="progress-bar progress-bar-greensea" role="progressbar" aria-valuenow="56" aria-valuemin="0" aria-valuemax="100" style="width: 56%;"></div>

                                                        </div>

                                                        <small>56%</small></td>

                                                    <td class="text-right"><span class="sparklineChart"

                                                                                 values="2,9,8,7,5,9,2,3,4,2"

                                                                                 sparkType="bar"

                                                                                 sparkBarColor="#16a085"

                                                                                 sparkBarWidth="4px"

                                                                                 sparkHeight="18px"> Loading...</span></td>

                                                </tr>

                                                <tr>

                                                    <td>5</td>

                                                    <td>Database migration</td>

                                                    <td><small class="text-success">Low Priority</small></td>

                                                    <td><div class="progress-xxs not-rounded mb-0 inline-block progress" style="width: 150px; margin-right: 5px">

                                                            <div class="progress-bar progress-bar-greensea" role="progressbar" aria-valuenow="48" aria-valuemin="0" aria-valuemax="100" style="width: 48%;"></div>

                                                        </div>

                                                        <small>48%</small></td>

                                                    <td class="text-right"><span class="sparklineChart"

                                                                                 values="3,5,6,2,8,9,5,4,3,2"

                                                                                 sparkType="bar"

                                                                                 sparkBarColor="#1693A5"

                                                                                 sparkBarWidth="4px"

                                                                                 sparkHeight="18px"> Loading...</span></td>

                                                </tr>

                                                <tr>

                                                    <td>6</td>

                                                    <td>Email server backup</td>

                                                    <td><small class="text-warning">Normal Priority</small></td>

                                                    <td><div class="progress-xxs not-rounded mb-0 inline-block progress" style="width: 150px; margin-right: 5px">

                                                            <div class="progress-bar progress-bar-greensea" role="progressbar" aria-valuenow="1" aria-valuemin="0" aria-valuemax="100" style="width: 10%;"></div>

                                                        </div>

                                                        <small>10%</small></td>

                                                    <td class="text-right"><span class="sparklineChart"

                                                                                 values="7,8,6,4,3,5,8,9,10,7"

                                                                                 sparkType="bar"

                                                                                 sparkBarColor="#3f4e62"

                                                                                 sparkBarWidth="4px"

                                                                                 sparkHeight="18px"> Loading...</span></td>

                                                </tr>

                                            </tbody>

                                        </table>

                                    </div>

                                </div>

                                <!-- /tile body --> 



                            </section>

                        </div>

                    </div>

                    <div class="row" style="display: none;">

                        <div class="col-md-4">

                            <section class="tile bg-greensea widget-appointments">

                                <div class="tile-header dvd dvd-btm">

                                    <h1 class="custom-font">Appointments</h1>

                                    <ul class="controls">

                                        <li class="dropdown"> <a role="button" tabindex="0" class="dropdown-toggle settings" data-toggle="dropdown"> <i class="fa fa-cog"></i> <i class="fa fa-spinner fa-spin"></i> </a>

                                            <ul class="dropdown-menu pull-right with-arrow animated littleFadeInUp br-5">

                                                <li> <a role="button" tabindex="0" class="tile-toggle"> <span class="minimize"><i class="fa fa-angle-down"></i>&nbsp;&nbsp;&nbsp;Minimize</span> <span class="expand"><i class="fa fa-angle-up"></i>&nbsp;&nbsp;&nbsp;Expand</span> </a> </li>

                                                <li> <a role="button" tabindex="0" class="tile-refresh"> <i class="fa fa-refresh"></i> Refresh </a> </li>

                                                <li> <a role="button" tabindex="0" class="tile-fullscreen"> <i class="fa fa-expand"></i> Fullscreen </a> </li>

                                            </ul>

                                        </li>

                                        <li class="remove"><a role="button" tabindex="0"  class="tile-close"><i class="fa fa-times"></i></a></li>

                                    </ul>

                                </div>

                                <div class="tile-body">

                                    <div class="row">

                                        <div class="col-md-6 text-center">

                                            <h4 class="text-light">Boston</h4>

                                            <div style="width: 100%;">

                                                <canvas id="c1" class="CoolClock:pixelClock:50"></canvas>

                                            </div>

                                            <span class="text-light">26&deg;C</span> </div>

                                        <div class="col-md-6 b-l text-center"> <span class="day">20</span><br/>

                                            <span class="month">March</span> </div>

                                    </div>

                                </div>

                                <div class="tile-footer dvd dvd-top">

                                    <div class="owl-carousel" id="appointments-carousel">

                                        <div>

                                            <p class="text-center text-strong"><i class="fa fa-clock-o"></i> 16:00, <small class="text-thin">Estimated time: 2 hours</small></p>

                                            <p>

                                            <h5 class="mt-10 mb-0 text-strong">Release Update</h5>

                                            <small class="text-thin text-transparent-white">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua...</small>

                                            </p>

                                        </div>

                                        <div>

                                            <p class="text-center text-strong"><i class="fa fa-clock-o"></i> 19:00, <small class="text-thin">Estimated time: 5 hours</small></p>

                                            <p>

                                            <h5 class="mt-10 mb-0 text-strong">Make a Backup</h5>

                                            <small class="text-thin text-transparent-white">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua...</small>

                                            </p>

                                        </div>

                                        <div>

                                            <p class="text-center text-strong"><i class="fa fa-clock-o"></i> 22:45, <small class="text-thin">Estimated time: 8 hours 45 minutes</small></p>

                                            <p>

                                            <h5 class="mt-10 mb-0 text-strong">Buy Tickets</h5>

                                            <small class="text-thin text-transparent-white">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua...</small>

                                            </p>

                                        </div>

                                    </div>

                                </div>

                            </section>

                        </div>

                        <div class="col-md-8">

                            <section class="tile widget-message" style="overflow:hidden;">

                                <div class="tile-header bg-slategray dvd dvd-btm">

                                    <h1 class="custom-font"><strong>Quick </strong>Message</h1>

                                    <ul class="controls">

                                        <li class="dropdown"> <a role="button" tabindex="0" class="dropdown-toggle settings" data-toggle="dropdown"> <i class="fa fa-cog"></i> <i class="fa fa-spinner fa-spin"></i> </a>

                                            <ul class="dropdown-menu pull-right with-arrow animated littleFadeInUp br-5">

                                                <li> <a role="button" tabindex="0" class="tile-toggle"> <span class="minimize"><i class="fa fa-angle-down"></i>&nbsp;&nbsp;&nbsp;Minimize</span> <span class="expand"><i class="fa fa-angle-up"></i>&nbsp;&nbsp;&nbsp;Expand</span> </a> </li>

                                                <li> <a role="button" tabindex="0" class="tile-refresh"> <i class="fa fa-refresh"></i> Refresh </a> </li>

                                                <li> <a role="button" tabindex="0" class="tile-fullscreen"> <i class="fa fa-expand"></i> Fullscreen </a> </li>

                                            </ul>

                                        </li>

                                        <li class="remove"><a role="button" tabindex="0" class="tile-close"><i class="fa fa-times"></i></a></li>

                                    </ul>

                                </div>

                                <div class="tile-widget bg-slategray">

                                    <form role="form">

                                        <div class="form-group">

                                            <select data-placeholder="Select recipients..." multiple="" tabindex="3" class="chosen-select input-underline" style="width: 100%;">

                                                <option value="ici@gmail.com">ji@gmail.com</option>

                                                <option value="johny@gmail.com">johny@gmail.com</option>

                                                <option value="arnie@gmail.com">Amish@gmail.com</option>

                                                <option value="pete@gmail.com">pete@gmail.com</option>

                                                <option value="gorge@gmail.com">gorge@gmail.com</option>

                                            </select>

                                        </div>

                                        <div class="form-group">

                                            <input type="text" class="form-control underline-input" placeholder="Type subject...">

                                        </div>

                                    </form>

                                </div>

                                <div class="tile-body p-0">

                                    <div id="summernote">Hello Summernote</div>

                                </div>

                                <div class="tile-footer bg-slategray text-right">

                                    <button class="btn bg-orange" activate-button="success"><i class="fa fa-send "></i> Send message</button>

                                </div>

                            </section>

                        </div>

                    </div>

                </div>

            </section>

            <!--/ CONTENT --> 



        </div>

        <!--/ Application Content --> 



        <!-- Vendor JavaScripts --> 

        <script src="assets/js/jquery.min.js"></script> 

        <script type="text/javascript">window.jQuery || document.write('<script src="assets/js/vendor/jquery/jquery-1.11.2.min.js"><\/script>')</script> 

        <script src="assets/js/vendor/bootstrap/bootstrap.min.js"></script> 

        <script src="assets/js/vendor/jRespond/jRespond.min.js"></script> 

        <script src="assets/js/vendor/d3/d3.min.js"></script> 

        <script src="assets/js/vendor/d3/d3.layout.min.js"></script> 

        <script src="assets/js/vendor/rickshaw/rickshaw.min.js"></script> 

        <script src="assets/js/vendor/sparkline/jquery.sparkline.min.js"></script> 

        <script src="assets/js/vendor/slimscroll/jquery.slimscroll.min.js"></script> 

        <script src="assets/js/vendor/animsition/js/jquery.animsition.min.js"></script> 

        <script src="assets/js/vendor/daterangepicker/moment.min.js"></script> 

        <script src="assets/js/vendor/daterangepicker/daterangepicker.js"></script> 

        <script src="assets/js/vendor/screenfull/screenfull.min.js"></script> 

        <script src="assets/js/vendor/flot/jquery.flot.min.js"></script> 

        <script src="assets/js/vendor/flot-tooltip/jquery.flot.tooltip.min.js"></script> 

        <script src="assets/js/vendor/flot-spline/jquery.flot.spline.min.js"></script> 

        <script src="assets/js/vendor/easypiechart/jquery.easypiechart.min.js"></script> 

        <script src="assets/js/vendor/raphael/raphael-min.js"></script> 

        <script src="assets/js/vendor/morris/morris.min.js"></script> 

        <script src="assets/js/vendor/owl-carousel/owl.carousel.min.js"></script> 

        <script src="assets/js/vendor/datetimepicker/js/bootstrap-datetimepicker.min.js"></script> 

        <script src="assets/js/vendor/datatables/js/jquery.dataTables.min.js"></script> 

        <script src="assets/js/vendor/datatables/extensions/dataTables.bootstrap.js"></script> 

        <script src="assets/js/vendor/chosen/chosen.jquery.min.js"></script> 

        <script src="assets/js/vendor/summernote/summernote.min.js"></script> 

        <script src="assets/js/vendor/coolclock/coolclock.js"></script> 

        <script src="assets/js/vendor/coolclock/excanvas.js"></script> 

        <!--/ vendor javascripts --> 

        <!-- Custom JavaScripts --> 

        <script src="assets/js/main.js"></script> 

        <!--/ custom javascripts --> 



        <script type="text/javascript" src="assets/js/loader.js"></script> 

        <script type="text/javascript">

                                google.charts.load('upcoming', {'packages': ['geochart']});

                                google.charts.setOnLoadCallback(drawRegionsMap);



                                function drawRegionsMap() {



                                    var data = google.visualization.arrayToDataTable([
                                        ['Country', 'Visitors'],
                                        ['Germany', 200],
                                        ['America', 600],
                                        ['Brazil', 100],
                                        ['Canada', 400],
                                        ['France', 190],
                                        ['RU', 210]

                                    ]);



                                    var options = {};



                                    var chart = new google.visualization.GeoChart(document.getElementById('regions_div'));



                                    chart.draw(data, options);

                                }

        </script> 



        <!-- Page Specific Scripts  --> 

        <script type="text/javascript">

            $(window).load(function () {



                //Initialize morris chart

                Morris.Donut({
                    element: 'browser-usage',
                    data: [
                        {label: 'Chrome', value: 25, color: '#74c7ff'},
                        {label: 'Safari', value: 20, color: '#aa9bff'},
                        {label: 'Firefox', value: 15, color: '#ff8fa7'},
                        {label: 'Opera', value: 5, color: '#66cd7d'},
                        {label: 'Internet Explorer', value: 10, color: '#5e90b5'},
                        {label: 'Other', value: 25, color: '#ffdc88'}

                    ],
                    resize: true

                });

                //*Initialize morris chart





                // Initialize owl carousels

                $('#todo-carousel, #feed-carousel, #notes-carousel').owlCarousel({
                    autoPlay: 5000,
                    stopOnHover: true,
                    slideSpeed: 300,
                    paginationSpeed: 400,
                    singleItem: true,
                    responsive: true

                });



                $('#appointments-carousel').owlCarousel({
                    autoPlay: 5000,
                    stopOnHover: true,
                    slideSpeed: 300,
                    paginationSpeed: 400,
                    navigation: true,
                    navigationText: ['<i class=\'fa fa-chevron-left\'></i>', '<i class=\'fa fa-chevron-right\'></i>'],
                    singleItem: true

                });

                //* Initialize owl carousels





                // Initialize rickshaw chart

                var graph;



                var seriesData = [[], []];

                var random = new Rickshaw.Fixtures.RandomData(50);



                for (var i = 0; i < 50; i++) {

                    random.addData(seriesData);

                }



                graph = new Rickshaw.Graph({
                    element: document.querySelector("#realtime-rickshaw"),
                    renderer: 'area',
                    height: 120,
                    series: [{
                            name: 'Series 1',
                            color: '#9675ce',
                            data: seriesData[0]

                        }, {
                            name: 'Series 2',
                            color: '#d4bdfa',
                            data: seriesData[1]

                        }]

                });



                var hoverDetail = new Rickshaw.Graph.HoverDetail({
                    graph: graph,
                });



                graph.render();



                setInterval(function () {

                    random.removeData(seriesData);

                    random.addData(seriesData);

                    graph.update();



                }, 1000);

                //* Initialize rickshaw chart



                //Initialize mini calendar datepicker

                $('#mini-calendar').datetimepicker({
                    inline: true

                });

                //*Initialize mini calendar datepicker





                //todo's

                $('.widget-todo .todo-list li .checkbox').on('change', function () {

                    var todo = $(this).parents('li');



                    if (todo.hasClass('completed')) {

                        todo.removeClass('completed');

                    } else {

                        todo.addClass('completed');

                    }

                });

                //* todo's





                //initialize datatable

                $('#project-progress').DataTable({
                    "aoColumnDefs": [
                        {'bSortable': false, 'aTargets': ["no-sort"]}

                    ],
                });

                //*initialize datatable



                //load wysiwyg editor

                $('#summernote').summernote({
                    toolbar: [
                        //['style', ['style']], // no style button

                        ['style', ['bold', 'italic', 'underline', 'clear']],
                        ['fontsize', ['fontsize']],
                        ['color', ['color']],
                        ['para', ['ul', 'ol', 'paragraph']],
                        ['height', ['height']],
                                //['insert', ['picture', 'link']], // no insert buttons

                                //['table', ['table']], // no table button

                                //['help', ['help']] //no help button

                    ],
                    height: 143   //set editable area's height

                });

                //*load wysiwyg editor

            });

        </script> 

        <!--/ Page Specific Scripts --> 



    </body>



</html>

