/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
$(document).ready(function () {
    $(".state_selection").change(function () {
        var stateId = $(this).val();
        var stateTx = $(this).find('option:selected').text();
        $(".state_name").val(stateTx);
        $.ajax({
            url: "process/API_AjaxCalling.php",
            type: 'POST', // http method
            data: "state=" + stateId + "&type=option&mode=state",
            success: function (result) {
//                console.log("SUCCESS :: " + result);
                if (result) {
                    $(".city_selection").html(result);
                }
            },
            error: function (jqXhr, textStatus, errorMessage) {
                console.log("ERROR :: " + errorMessage);
            }
        });
    });
    $(".city_selection").change(function () {
        var stateId = $(this).val();
        var stateTx = $(this).find('option:selected').text();
        $(".city_name").val(stateTx);
    });
//    $(".store_selection").change(function () {
//        var stateId = $(this).val();
//        var stateTx = $(this).find('option:selected').text();
//        $(".store_name").val(stateTx);
//    });

    $(".client_selection").change(function () {
        var clientId = $(this).val();
        var clientTx = $(this).find('option:selected').text();
        var clientUn = $(this).find('option:selected').attr('data-unique');
        $(".client_id").val(clientId);
        if ($(".store_client_unique")) {
            $(".store_client_unique").val(clientUn);
        }
        if ($(".user_client_unique")) {
            $(".user_client_unique").val(clientUn);
        }
    });
    $(".store_selection").change(function () {
        var storeId = $(this).val();
        var storeTx = $(this).find('option:selected').text();
        var storeUn = $(this).find('option:selected').attr('data-unique');
        var storeNm = $(this).find('option:selected').attr('data-name');
        $(".store_id").val(storeId);
        $(".user_store_unique").val(storeUn);
        if ($(".user_store_name")) {
            $(".user_store_name").val(storeNm);
        }
    });
    $(".onlyNumbers").keypress(function (e) {
//if the letter is not digit then display error and don't type anything
        if (e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
//display error message
            $("#errmsg").html("Digits Only").show().fadeOut(1000); //"slow");
            return false;
        }
    });
});
function onlyNumbers(thisVal, thisId) {
    thisVal = thisVal.replace(/[^0-9]/g, '');
//    thisVal = thisVal.replace(/(\..*)\./g, '$1');
//    thisVal = thisVal.replace(/^(-?).*?(\d+\.\d{2}).*$/, '$1$2');
    $("#" + thisId).val(thisVal);
}
function getRecordList(recordName = '', extData = '') {
//    console.log("CALLING :: " + recordName + " || extData :: " + extData);
    if (recordName == 'sales_index') {
        if (extData != '')
            extData = "&" + extData;
        recordName = "sale";
    }
    $("." + recordName + "_list_data").hide();
    $("." + recordName + "_list_loading").show();
    setTimeout(function () {
        $.ajax({
            url: "process/API_AjaxCalling.php",
            type: 'POST', // http method
            dataType: 'html',
            data: "mode=" + recordName + "_index" + extData,
            async: false,
            success: function (result) {
//                console.log("SUCCESS :: " + result);
                if (result) {
                    $("." + recordName + "_list_data").html('');
                    $("." + recordName + "_list_data").append(result);
                    $('.footable').footable();
                }

                $("." + recordName + "_list_loading").hide();
                $("." + recordName + "_list_data").show();
            },
            error: function (jqXhr, textStatus, errorMessage) {
                console.log("ERROR :: " + errorMessage);
            }
        });
    }, 2000);
}


function getProductList() {
    getRecordList('product');
}

function getStockList() {
    getRecordList('stock');
}

function getInventoryList() {
    getRecordList('inventory');
}

function getSupplierList() {
    getRecordList('supplier');
}

function getOperatorList() {
    getRecordList('operator');
}

function getUploadDataList() {
    var t = 120;
    if (prevTimeInterval) {
        clearInterval(prevTimeInterval);
    }
    getRecordList('upload_data');
    prevTimeInterval = setInterval(function () {
        if (t >= 0) {
            document.getElementById("upload_timer").innerHTML = t;
            t--;
        } else {
            t = 60;
        }
    }, 1010);
}

function getSalesList() {
    var extData = '';
    var filterSearch = $("#filterSearch").val();
    if (filterSearch != '') {
        extData = filterSearch;
    }
    getRecordList('sales_index', extData);
}


function setSaleData() {
    setTimeout(function () {
        $('.footable').footable();
        $(".sale_list_loading").hide();
        $(".sale_list_data").show();
    }, 600);
}
function getSalesMonthlyList() {
    console.log("CALLING :: ");
    var respponse = '';
    $.ajax({
        url: "process/API_AjaxCalling.php",
        type: 'POST', // http method
        dataType: 'html',
        data: "mode=sales_monthly",
        async: false,
        success: function (result) {
            respponse = result;
            $("#dashSale").val(respponse);
        },
        error: function (jqXhr, textStatus, errorMessage) {
            console.log("ERROR :: " + errorMessage);
        }
    });
//    setTimeout(function () {
////        updateChart();
//    }, 2000);
    return respponse;
}



function ajaxCalling(ajaxUrl, ajaxType, ajaxDataType, ajaxData, ajaxAsync, ajaxReturnResult) {
    var response = '';
    $.ajax({
        url: ajaxUrl || "process/API_AjaxCalling.php",
        type: ajaxType || 'POST', // http method
        dataType: ajaxDataType || 'html',
        data: ajaxData,
        async: ajaxAsync || false,
        success: function (result) {
            if (result && ajaxReturnResult) {
                response = result;
            }
        },
        error: function (jqXhr, textStatus, errorMessage) {
            console.log("ERROR :: " + errorMessage);
        }
    });
    return response;
}

function unMapDeviceId(thisObj, usid, us_ty, dv_id) {
    var r = confirm("Are you sure, You want to change the device id. \n\
If data is not updated on server then you may be lost your data. Are you sure you want to proceed.");
    if (r === true) {
        var response = ajaxCalling('', '', '',
                "mode=update_user_device&us_id=" + usid + "&us_ty=" + us_ty + "&dv_id=" + dv_id + "&type=un",
                false, true);
        if (response == 'success') {
            $(thisObj).closest("tr").find('.device_id_class').html("");
        }
    }
}


function resetSyncStatus(thisObj, upid, usid, updt) {
    var r = confirm("Are you sure, You want to change the sync status. \n\
            All updated data will be deleted and if backup file is not curropcted then data can be recovered else all data will be loss.");
    if (r === true) {
        var response = ajaxCalling('', '', '',
                "mode=update_sync_status&upid=" + upid + "&usid=" + usid + "&updt=" + updt,
                false, true);
        if (response == 'success') {
            $(thisObj).hide();
        }
        if (response == 'NA') {
            alert("You are not authrosiszed to access this");
        }
        if (response == 'failed') {
            alert("Process can't be processed. Please try after some time");
        }
    }
}

function getProductDetailsBarcode(thisObj, barCode) {

    var response = ajaxCalling('', '', '',
            "mode=product_barcode&bar_code=" + barCode,
            false, true);
    $("#outputBarcode").html('');
    $("#scanBarcode").hide();
    $("#searchBarcode").show();
    $("#outputBarcode").append(response);
    $("#stop").trigger('click');
}

